<?php
$name = (isset($_POST['name']) ? $_POST['name'] : $_GET['name']);
$cols = (isset($_POST['cols']) ? $_POST['cols'] : $_GET['cols']);
$data = (isset($_POST['data']) ? $_POST['data'] : $_GET['data']);
$label = (isset($_POST['label']) || isset($_GET['label']));

header("Pragma: public");
header("Expires: 0");
header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
header("Cache-Control: private", false);
header("Content-Type: application/data");
header("Content-Disposition: attachment; filename=\"".($name ? $name : 'data.csv')."\";");
header("Content-Transfer-Encoding: binary");

for($i = 0; $i < count($cols); $i += 1) {
  if($i != 0) { echo ","; }
  echo csvify($cols[$i]);
}
echo "\n";

foreach($data as $key => $row) {
  for($i = 0; $i < count($cols); $i += 1) {
    if($i != 0) { echo ","; }
    if(isset($row[($label ? $cols[$i] : $i)])) {
      echo csvify($row[($label ? $cols[$i] : $i)]);
    }
  }
  echo "\n";
}

function csvify($s) {
  if(!preg_match('/[,"]/',$s)) { return $s; }
  return '"'.preg_replace('/"/','""',$s).'"';
}
?>