function EmptyIterator() {
  this.first = 1;
  this.hasNext = function() {
    return this.first;
  };
  this.next = function() {
    this.first = 0; return "";
  };
  this.reset = function() {
    this.first = 1;
  };
}

function IntervalIterator(f,t,s) {
  this.f = f; this.t = t; this.s = s;
  this.i = f;
  this.hasNext = function() {
    if(this.s < 0 && this.i >= this.t) return 1;
    if(this.s > 0 && this.i <= this.t) return 1;
    return 0;
  };
  this.next = function() {
    var t = this.i; this.i += this.s; return t;
  };
  this.reset = function() {
    this.i = this.f;
  };
}

function Interval(f,t,s) {
  this.f = f; if(f == undefined) this.f = 1;
  this.t = t; if(t == undefined) this.t = 10;
  this.s = s; if(s == undefined) this.s = 1;
  this.render = function() {
    var me = this;
    function fix(){if(me.f<me.t){if(me.s<0){me.s=-me.s}}else{if(me.s>0){me.s=-me.s}}}
    var wrap = document.createElement('div');
    var lower = document.createElement('input');
    lower.type = 'text'; lower.size = 5;
    lower.value = ""+this.f; wrap.appendChild(lower);
    lower.addEventListener('keyup',function(){me.f=parseFloat(lower.value);fix()},false);
    wrap.appendChild(document.createTextNode('-'));
    var upper = document.createElement('input');
    upper.type = 'text'; upper.size = 5;
    upper.value = ""+this.t; wrap.appendChild(upper);
    upper.addEventListener('keyup',function(){me.t=parseFloat(upper.value);fix()},false);
    wrap.appendChild(document.createTextNode(','));
    var step = document.createElement('input');
    step.type = 'text'; step.size = 5;
    step.value = ""+this.s; wrap.appendChild(step);
    step.addEventListener('keyup',function(){me.s=parseFloat(step.value);fix()},false);
    return wrap;
  };
  this.iterator = function() { return new IntervalIterator(this.f,this.t,this.s); };
}

function EnumIterator(vs) {
  this.vs = vs;
  this.i = 0;
  this.hasNext = function() {
    return (this.i < this.vs.length);
  };
  this.next = function() {
    var t = this.vs[this.i]; this.i += 1; return t;
  };
  this.reset = function() {
    this.i = 0;
  };
}

function Enum() {
  this.wrap = null;
  this.values = [];
  this._add = function() {
    var me = this;
    var idx = this.values.length;
    this.values[idx] = "";
    var input = document.createElement('input');
    input.type = 'text'; input.size = 8; input.value = "";
    input.addEventListener('keydown',function(e) {
        if(!e || e.keyCode != 9 || e.altKey || e.ctrlKey || e.shiftKey) return;
        e.preventDefault();
        me._add().focus();
      },false);
    input.addEventListener('keyup',function(){me.values[idx]=input.value},false);
    this.wrap.appendChild(input);
    return input;
  };
  this.render = function() {
    var me = this;
    var wwrap = document.createElement('div');
    this.wrap = document.createElement('div');
    this.wrap.style.display = 'inline';
    wwrap.appendChild(this.wrap);
    var plus = document.createElement('input');
    plus.type = 'button'; plus.value = '+';
    plus.addEventListener('click',function(){me._add()},false);
    wwrap.appendChild(plus);
    this._add();
    return wwrap;
  };
  this.iterator = function() { return new EnumIterator(this.values); };
}

function CEnumIterator(data) {
  this.data = [];
  var piece = "";
  var esc = false;
  for(var i = 0; i < data.length; i++) {
    if(data.charAt(i) == "\\") {
      if(esc) { piece += "\\"; }
      esc = !esc;
      continue;
    } else if(data.charAt(i) == ",") {
      if(esc) { piece += ","; }
      else {
        this.data.push(piece);
        piece = "";
      }
    } else {
      piece += data.charAt(i);
    }
    esc = false;
  }
  this.data.push(piece);
  this.i = 0;
  this.hasNext = function() {
    return (this.i < this.data.length);
  };
  this.next = function() {
    var t = this.data[this.i]; this.i += 1; return t;
  };
  this.reset = function() {
    this.i = 0;
  };
}

function CEnum() {
  this.wrap = null;
  this.data = {value:""};
  this.render = function() {
    var me = this;
    var wrap = document.createElement('div');
    this.data = document.createElement('input');
    this.data.size = 150; this.data.value = "";
    wrap.appendChild(this.data);
    return wrap;
  };
  this.iterator = function() { return new CEnumIterator(this.data.value); };
}

function Variable(name) {
  this.name = name;
  this.varo = null;
  this.vartd = null;
  this.tnames = ['Interval', 'Enum', 'CEnum'];
  this.tmap = {'Interval': window.Interval, 'Enum': window.Enum, 'CEnum': window.CEnum};
  this.render = function() {
    var me = this;
    var tr = document.createElement('tr');
    var label = document.createElement('td');
    label.textContent = this.name;
    tr.appendChild(label);
    var type = document.createElement('td');
    var select = document.createElement('select');
    this.vartd = document.createElement('td');
    for(var i = 0; i < this.tnames.length; i++) {
      var option = document.createElement('option');
      option.value = this.tnames[i];
      option.textContent = this.tnames[i];
      if(i == 0) {
        option.selected = 'selected';
        this.varo = new this.tmap[this.tnames[i]];
        this.vartd.appendChild(this.varo.render());
      }
      select.appendChild(option);
    }
    type.appendChild(select);
    tr.appendChild(type);
    tr.appendChild(this.vartd);
    select.addEventListener('change',function() {
        while(me.vartd.firstChild) { me.vartd.removeChild(me.vartd.firstChild); }
        if(!me.tmap[select.value]) { me.varo = null; return; }
        me.varo = new me.tmap[select.value];
        me.vartd.appendChild(me.varo.render());
      },false);
    return tr;
  };
  this.iterator = function() {
    if(!this.varo) return new EmptyIterator();
    return this.varo.iterator();
  };
}
